/**************************************************************************************
 Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: CclIeFbIf_Public.h 85876 2019-09-19 10:08:43Z Sven $:
**************************************************************************************/

#ifndef _CCLIEFBIF_PUBLIC_H
#define _CCLIEFBIF_PUBLIC_H

#include <stdint.h>
#include <Hil_Packet.h>

#define CCLIEFB_IF_QUEUE_NAME "CCLIEFB_IF_QUE"

#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(CCLIEFBIF_PUBLIC_H)
#endif

#define CCLIEFB_CMD_SET_CONFIG_REQ 0xAA00
#define CCLIEFB_CMD_SET_CONFIG_CNF 0xAA01

#define CCLIEFB_CMD_STATUS_IND 0xAA20
#define CCLIEFB_CMD_STATUS_RES 0xAA21

#define CCLIEFB_CMD_GET_STATUS_REQ 0xAA22
#define CCLIEFB_CMD_GET_STATUS_CNF 0xAA23

#define CCLIEFB_CMD_REGISTER_APP_REQ 0xAA54
#define CCLIEFB_CMD_REGISTER_APP_CNF 0xAA55

#define CCLIEFB_CMD_UNREGISTER_APP_REQ 0xAA56
#define CCLIEFB_CMD_UNREGISTER_APP_CNF 0xAA57

#define CCLIEFB_CMD_REGISTER_STATION_ID_UPDATE_REQ 0xAA60
#define CCLIEFB_CMD_REGISTER_STATION_ID_UPDATE_CNF 0xAA61

#define CCLIEFB_CMD_UNREGISTER_STATION_ID_UPDATE_REQ 0xAA62
#define CCLIEFB_CMD_UNREGISTER_STATION_ID_UPDATE_CNF 0xAA63

#define CCLIEFB_CMD_STATION_ID_UPDATE_IND 0xAA64
#define CCLIEFB_CMD_STATION_ID_UPDATE_RES 0xAA65

#define CCLIEFB_CMD_SLMP_REGISTER_INDICATION_REQ 0xAA80
#define CCLIEFB_CMD_SLMP_REGISTER_INDICATION_CNF 0xAA81

#define CCLIEFB_CMD_SLMP_UNREGISTER_INDICATION_REQ 0xAA82
#define CCLIEFB_CMD_SLMP_UNREGISTER_INDICATION_CNF 0xAA83

#define CCLIEFB_CMD_SLMP_REQUEST_IND 0xAA84
#define CCLIEFB_CMD_SLMP_REQUEST_RES 0xAA85

#define CCLIEFB_CMD_SLMP_SEND_REQUEST_REQ 0xAAAA
#define CCLIEFB_CMD_SLMP_SEND_REQUEST_CNF 0xAAAB

/******************************************************************************
 * Packet: CCLIEFB_CMD_SET_CONFIG_REQ/CCLIEFB_CMD_SET_CONFIG_CNF
 */

/* request packet */
typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_SET_CONFIG_REQ_DATA_Ttag
{
  uint32_t ulSystemFlags;
  uint32_t ulWatchdogTime;

  uint32_t ulStationId;
  uint32_t ulSubnetMask;
  uint32_t ulDefGatewayId;

  uint16_t usVendorCode;
  uint32_t ulModelCode;
  uint16_t usEquipmentVersion;
  uint8_t bNumOccupiedStations;
} CCLIEFB_SET_CONFIG_REQ_DATA_T;

typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_SET_CONFIG_REQ_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIEFB_SET_CONFIG_REQ_DATA_T tData;
} CCLIEFB_SET_CONFIG_REQ_T;


/* confirmation packet */
typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_SET_CONFIG_CNF_Ttag
{
  HIL_PACKET_HEADER_T tHead;
} CCLIEFB_SET_CONFIG_CNF_T;


/* packet union */
typedef union CCLIEFB_SET_CONFIG_PCK_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIEFB_SET_CONFIG_REQ_T tReq;
  CCLIEFB_SET_CONFIG_CNF_T tCnf;
} CCLIEFB_SET_CONFIG_PCK_T;


/******************************************************************************
 * Packet: CCLIEFB_CMD_STATUS_IND/CCLIEFB_CMD_STATUS_RES
 */

#define VAL_CCLIEFB_STATUS_IND_LED_STATUS_OFF 0
#define VAL_CCLIEFB_STATUS_IND_LED_STATUS_ON 1
#define VAL_CCLIEFB_STATUS_IND_LED_STATUS_BLINKING 2

#define MSK_CCLIEFB_STATUS_IND_BUS_STATUS_SLAVE_DUPLICATION 0x00000001
#define MSK_CCLIEFB_STATUS_IND_BUS_STATUS_MASTER_ARBITRATION 0x00000002
#define MSK_CCLIEFB_STATUS_IND_BUS_STATUS_OTHER_MASTER_ACTIVE 0x00000004
#define MSK_CCLIEFB_STATUS_IND_BUS_STATUS_IS_SLAVE 0x40000000
#define MSK_CCLIEFB_STATUS_IND_BUS_STATUS_IS_MASTER 0x80000000

/* indication packet */
typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_STATUS_IND_DATA_OWN_STATUS_Ttag
{
  uint8_t bRunCondition;
  uint8_t bErrorCondition;
  uint8_t bBusOnCondition;
  uint8_t bConfiguredCondition;
  uint32_t ulBusStatus;
} CCLIEFB_STATUS_IND_DATA_OWN_STATUS_T;

typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_STATUS_IND_DATA_REMOTE_STATUS_Ttag
{
  uint8_t abStatusMask[8];
} CCLIEFB_STATUS_IND_DATA_REMOTE_STATUS_T;

typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_STATUS_IND_DATA_LED_Ttag
{
  uint8_t bStatusLed;
  uint8_t bErrorLed;
} CCLIEFB_STATUS_IND_DATA_LED_T;

typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_STATUS_IND_DATA_Ttag
{
  CCLIEFB_STATUS_IND_DATA_OWN_STATUS_T tOwnStatus;
  CCLIEFB_STATUS_IND_DATA_REMOTE_STATUS_T tRemoteStatus;
  CCLIEFB_STATUS_IND_DATA_LED_T tLedStatus;
} CCLIEFB_STATUS_IND_DATA_T;

typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_STATUS_IND_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIEFB_STATUS_IND_DATA_T tData;
} CCLIEFB_STATUS_IND_T;


/* response packet */
typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_STATUS_RES_Ttag
{
  HIL_PACKET_HEADER_T tHead;
} CCLIEFB_STATUS_RES_T;


/* packet union */
typedef union CCLIEFB_STATUS_PCK_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIEFB_STATUS_IND_T tInd;
  CCLIEFB_STATUS_RES_T tRes;
} CCLIEFB_STATUS_PCK_T;


/******************************************************************************
 * Packet: CCLIEFB_CMD_GET_STATUS_REQ/CCLIEFB_CMD_GET_STATUS_CNF
 */

#define VAL_CCLIEFB_GET_STATUS_CNF_LED_STATUS_OFF 0
#define VAL_CCLIEFB_GET_STATUS_CNF_LED_STATUS_ON 1
#define VAL_CCLIEFB_GET_STATUS_CNF_LED_STATUS_BLINKING 2

#define MSK_CCLIEFB_GET_STATUS_CNF_BUS_STATUS_SLAVE_DUPLICATION 0x00000001
#define MSK_CCLIEFB_GET_STATUS_CNF_BUS_STATUS_MASTER_ARBITRATION 0x00000002
#define MSK_CCLIEFB_GET_STATUS_CNF_BUS_STATUS_OTHER_MASTER_ACTIVE 0x00000004
#define MSK_CCLIEFB_GET_STATUS_CNF_BUS_STATUS_IS_SLAVE 0x40000000
#define MSK_CCLIEFB_GET_STATUS_CNF_BUS_STATUS_IS_MASTER 0x80000000

/* request packet */
typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_GET_STATUS_REQ_Ttag
{
  HIL_PACKET_HEADER_T tHead;
} CCLIEFB_GET_STATUS_REQ_T;


/* confirmation packet */
typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_GET_STATUS_CNF_DATA_OWN_STATUS_Ttag
{
  uint8_t bRunCondition;
  uint8_t bErrorCondition;
  uint8_t bBusOnCondition;
  uint8_t bConfiguredCondition;
  uint32_t ulBusStatus;
} CCLIEFB_GET_STATUS_CNF_DATA_OWN_STATUS_T;

typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_GET_STATUS_CNF_DATA_REMOTE_STATUS_Ttag
{
  uint8_t abStatusMask[8];
} CCLIEFB_GET_STATUS_CNF_DATA_REMOTE_STATUS_T;

typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_GET_STATUS_CNF_DATA_LED_Ttag
{
  uint8_t bStatusLed;
  uint8_t bErrorLed;
} CCLIEFB_GET_STATUS_CNF_DATA_LED_T;

typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_GET_STATUS_CNF_DATA_Ttag
{
  CCLIEFB_GET_STATUS_CNF_DATA_OWN_STATUS_T tOwnStatus;
  CCLIEFB_GET_STATUS_CNF_DATA_REMOTE_STATUS_T tRemoteStatus;
  CCLIEFB_GET_STATUS_CNF_DATA_LED_T tLedStatus;
} CCLIEFB_GET_STATUS_CNF_DATA_T;

typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_GET_STATUS_CNF_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIEFB_GET_STATUS_CNF_DATA_T tData;
} CCLIEFB_GET_STATUS_CNF_T;


/* packet union */
typedef union CCLIEFB_GET_STATUS_PCK_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIEFB_GET_STATUS_REQ_T tReq;
  CCLIEFB_GET_STATUS_CNF_T tCnf;
} CCLIEFB_GET_STATUS_PCK_T;

typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_PROCESS_IMAGE_SECTION_TX_Ttag
{
  uint8_t bCyclicState;
  uint8_t bCyclicStop; /* master only */
  uint16_t usLocalStationInfo; /* only first block in process image */
  uint16_t ausReserved[2];
  uint16_t ausWordData[32];
  uint8_t abBitData[8];
} CCLIEFB_PROCESS_IMAGE_SECTION_TX_T;

#define MSK_CCLIEFB_PROCESS_IMAGE_CYCLIC_STOP_SET 0x01

typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_PROCESS_IMAGE_SECTION_RX_Ttag
{
  uint8_t bCyclicState;
  uint8_t bStationState;
  uint16_t usRemoteStationInfo;
  uint16_t usCyclicEndCode;
  uint16_t usReserved;
  uint16_t ausWordData[32];
  uint8_t abBitData[8];
} CCLIEFB_PROCESS_IMAGE_SECTION_RX_T;

#define MSK_CCLIEFB_PROCESS_IMAGE_CYCLIC_STATE_DATA_VALID 0x01

#define MSK_CCLIEFB_PROCESS_IMAGE_STATION_STATE_ACTIVE 0x01

/******************************************************************************
 * Packet:  CCLIEFB_CMD_SLMP_REGISTER_INDICATION_REQ/CCLIEFB_CMD_SLMP_REGISTER_INDICATION_CNF
 */

/* request packet */
typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_SLMP_REGISTER_INDICATION_REQ_DATA_Ttag
{
  uint16_t usTypeFlags;
  uint16_t usCommand;
  uint16_t usSubCommand;
} CCLIEFB_SLMP_REGISTER_INDICATION_REQ_DATA_T;

typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_SLMP_REGISTER_INDICATION_REQ_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIEFB_SLMP_REGISTER_INDICATION_REQ_DATA_T tData;
} CCLIEFB_SLMP_REGISTER_INDICATION_REQ_T;


/* confirmation packet */
typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_SLMP_REGISTER_INDICATION_CNF_DATA_Ttag
{
  uint16_t usTypeFlags;
  uint16_t usCommand;
  uint16_t usSubCommand;
  uint32_t ulHandle;
} CCLIEFB_SLMP_REGISTER_INDICATION_CNF_DATA_T;

#define MSK_CCLIEFB_SLMP_REGISTER_INDICATION_TYPE_FLAGS_ST 0x0001
#define MSK_CCLIEFB_SLMP_REGISTER_INDICATION_TYPE_FLAGS_MT 0x0002
#define MSK_CCLIEFB_SLMP_REGISTER_INDICATION_TYPE_FLAGS_EMT 0x0004

typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_SLMP_REGISTER_INDICATION_CNF_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIEFB_SLMP_REGISTER_INDICATION_CNF_DATA_T tData;
} CCLIEFB_SLMP_REGISTER_INDICATION_CNF_T;


/* packet union */
typedef union CCLIEFB_SLMP_REGISTER_INDICATION_PCK_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIEFB_SLMP_REGISTER_INDICATION_REQ_T tReq;
  CCLIEFB_SLMP_REGISTER_INDICATION_CNF_T tCnf;
} CCLIEFB_SLMP_REGISTER_INDICATION_PCK_T;


/******************************************************************************
 * Packet:  CCLIEFB_CMD_SLMP_UNREGISTER_INDICATION_REQ/CCLIEFB_CMD_SLMP_UNREGISTER_INDICATION_CNF
 */

/* request packet */
typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_SLMP_UNREGISTER_INDICATION_REQ_DATA_Ttag
{
  uint32_t ulHandle;
} CCLIEFB_SLMP_UNREGISTER_INDICATION_REQ_DATA_T;

typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_SLMP_UNREGISTER_INDICATION_REQ_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIEFB_SLMP_UNREGISTER_INDICATION_REQ_DATA_T tData;
} CCLIEFB_SLMP_UNREGISTER_INDICATION_REQ_T;


/* confirmation packet */
typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_SLMP_UNREGISTER_INDICATION_CNF_Ttag
{
  HIL_PACKET_HEADER_T tHead;
} CCLIEFB_SLMP_UNREGISTER_INDICATION_CNF_T;


/* packet union */
typedef union CCLIEFB_SLMP_UNREGISTER_INDICATION_PCK_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIEFB_SLMP_UNREGISTER_INDICATION_REQ_T tReq;
  CCLIEFB_SLMP_UNREGISTER_INDICATION_CNF_T tCnf;
} CCLIEFB_SLMP_UNREGISTER_INDICATION_PCK_T;


/******************************************************************************
 * Packet:  CCLIEFB_CMD_SLMP_REQUEST_IND/CCLIEFB_CMD_SLMP_REQUEST_RES
 */

/* request packet */
typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_SLMP_REQUEST_IND_DATA_Ttag
{
  uint16_t usReceivedOnPort; /* UDP port */
  uint16_t usFormatType;
  uint16_t usCommand;
  uint16_t usSubCommand;
  uint32_t ulTimeoutMs;
  uint16_t usDataBytes;
  uint8_t abData[1024];
} CCLIEFB_SLMP_REQUEST_IND_DATA_T;

/* usFormatType */
#define CCLIEFB_SLMP_REQUEST_IND_FORMAT_TYPE_BINARY 0
#define CCLIEFB_SLMP_REQUEST_IND_FORMAT_TYPE_ASCII 1

typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_SLMP_REQUEST_IND_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIEFB_SLMP_REQUEST_IND_DATA_T tData;
} CCLIEFB_SLMP_REQUEST_IND_T;


/* confirmation packet */
typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_SLMP_REQUEST_RES_DATA_Ttag
{
  uint16_t usDataBytes;
  uint8_t abData[1024];
} CCLIEFB_SLMP_REQUEST_RES_DATA_T;

typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_SLMP_REQUEST_RES_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIEFB_SLMP_REQUEST_RES_DATA_T tData;
} CCLIEFB_SLMP_REQUEST_RES_T;


/* packet union */
typedef union CCLIEFB_SLMP_REQUEST_PCK_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIEFB_SLMP_REQUEST_IND_T tInd;
  CCLIEFB_SLMP_REQUEST_RES_T tRes;
} CCLIEFB_SLMP_REQUEST_PCK_T;

/******************************************************************************
 * CCLIEFB_CMD_SLMP_SEND_REQUEST_REQ/CCLIEFB_CMD_SLMP_SEND_REQUEST_CNF
 */

#define CCLIEFB_SLMP_SEND_REQUEST_MAX_DATA_BYTES 1024

/* request packet */
typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_SLMP_SEND_REQUEST_REQ_DATA_Ttag
{
  uint16_t usProtocol;
  uint16_t usRequestType;
  uint16_t usFormatType;
  uint16_t usDstProcNo;
  uint16_t usCommand;
  uint16_t usSubCommand;
  uint32_t ulTimeoutMs;
  uint32_t ulDestAddr;
  uint16_t usDestPort;
  uint16_t usTotalReqDataBytes;
  uint8_t abReqData[CCLIEFB_SLMP_SEND_REQUEST_MAX_DATA_BYTES];
} CCLIEFB_SLMP_SEND_REQUEST_REQ_DATA_T;

#define CCLIEFB_SLMP_SEND_REQUEST_TYPE_ST 0x0050
#define CCLIEFB_SLMP_SEND_REQUEST_TYPE_ST_PUSHONLY 0x00D0
#define CCLIEFB_SLMP_SEND_REQUEST_TYPE_MT 0x0054
#define CCLIEFB_SLMP_SEND_REQUEST_TYPE_MT_PUSHONLY 0x00D4
#define CCLIEFB_SLMP_SEND_REQUEST_TYPE_EMT 0x0055
#define CCLIEFB_SLMP_SEND_REQUEST_TYPE_EMT_PUSHONLY 0x00D5

#define CCLIEFB_SLMP_SEND_REQUEST_PROTOCOL_TCP 0
#define CCLIEFB_SLMP_SEND_REQUEST_PROTOCOL_UDP 1

/* usFormatType */
#define CCLIEFB_SLMP_SEND_REQUEST_FORMAT_TYPE_BINARY 0
#define CCLIEFB_SLMP_SEND_REQUEST_FORMAT_TYPE_ASCII 1

typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_SLMP_SEND_REQUEST_REQ_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIEFB_SLMP_SEND_REQUEST_REQ_DATA_T tData;
} CCLIEFB_SLMP_SEND_REQUEST_REQ_T;


/* confirmation packet */
typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_SLMP_SEND_REQUEST_CNF_DATA_Ttag
{
  uint16_t usProtocol;
  uint16_t usFrameType;
  uint16_t usFormatType;
  uint16_t usDstProcNo;
  uint16_t usCommand;
  uint16_t usSubCommand;
  uint32_t ulTimeoutMs;
  uint32_t ulDestAddr;
  uint16_t usDestPort;
  uint16_t usTotalResDataBytes;
  uint8_t abResData[CCLIEFB_SLMP_SEND_REQUEST_MAX_DATA_BYTES];
} CCLIEFB_SLMP_SEND_REQUEST_CNF_DATA_T;

typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_SLMP_SEND_REQUEST_CNF_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIEFB_SLMP_SEND_REQUEST_CNF_DATA_T tData;
} CCLIEFB_SLMP_SEND_REQUEST_CNF_T;


/* packet union */
typedef union CCLIEFB_SLMP_SEND_REQUEST_PCK_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIEFB_SLMP_SEND_REQUEST_REQ_T tReq;
  CCLIEFB_SLMP_SEND_REQUEST_CNF_T tCnf;
} CCLIEFB_SLMP_SEND_REQUEST_PCK_T;

/******************************************************************************
 * CCLIEFB_CMD_REGISTER_STATION_ID_UPDATE_REQ/CCLIEFB_CMD_REGISTER_STATION_ID_UPDATE_CNF
 */

/* request packet */
typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_REGISTER_STATION_ID_UPDATE_REQ_Ttag
{
  HIL_PACKET_HEADER_T tHead;
} CCLIEFB_REGISTER_STATION_ID_UPDATE_REQ_T;


/* confirmation packet */
typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_REGISTER_STATION_ID_UPDATE_CNF_Ttag
{
  HIL_PACKET_HEADER_T tHead;
} CCLIEFB_REGISTER_STATION_ID_UPDATE_CNF_T;


/* packet union */
typedef union CCLIEFB_REGISTER_STATION_ID_UPDATE_PCK_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIEFB_REGISTER_STATION_ID_UPDATE_REQ_T tReq;
  CCLIEFB_REGISTER_STATION_ID_UPDATE_CNF_T tCnf;
} CCLIEFB_REGISTER_STATION_ID_UPDATE_PCK_T;

/******************************************************************************
 * CCLIEFB_CMD_UNREGISTER_STATION_ID_UPDATE_REQ/CCLIEFB_CMD_UNREGISTER_STATION_ID_UPDATE_CNF
 */

/* request packet */
typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_UNREGISTER_STATION_ID_UPDATE_REQ_Ttag
{
  HIL_PACKET_HEADER_T tHead;
} CCLIEFB_UNREGISTER_STATION_ID_UPDATE_REQ_T;


/* confirmation packet */
typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_UNREGISTER_STATION_ID_UPDATE_CNF_Ttag
{
  HIL_PACKET_HEADER_T tHead;
} CCLIEFB_UNREGISTER_STATION_ID_UPDATE_CNF_T;


/* packet union */
typedef union CCLIEFB_UNREGISTER_STATION_ID_UPDATE_PCK_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIEFB_UNREGISTER_STATION_ID_UPDATE_REQ_T tReq;
  CCLIEFB_UNREGISTER_STATION_ID_UPDATE_CNF_T tCnf;
} CCLIEFB_UNREGISTER_STATION_ID_UPDATE_PCK_T;

/******************************************************************************
 * CCLIEFB_CMD_STATION_ID_UPDATE_IND/CCLIEFB_CMD_STATION_ID_UPDATE_RES
 */

/* indication packet */
typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_STATION_ID_UPDATE_IND_DATA_Ttag
{
  uint32_t ulStationId;
  uint32_t ulSubnetMask;
  uint32_t ulDefGatewayId;
} CCLIEFB_STATION_ID_UPDATE_IND_DATA_T;

typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_STATION_ID_UPDATE_IND_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIEFB_STATION_ID_UPDATE_IND_DATA_T tData;
} CCLIEFB_STATION_ID_UPDATE_IND_T;


/* response packet */
typedef __HIL_PACKED_PRE struct __HIL_PACKED_POST CCLIEFB_STATION_ID_UPDATE_RES_Ttag
{
  HIL_PACKET_HEADER_T tHead;
} CCLIEFB_STATION_ID_UPDATE_RES_T;


/* packet union */
typedef union CCLIEFB_STATION_ID_UPDATE_PCK_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIEFB_STATION_ID_UPDATE_IND_T tInd;
  CCLIEFB_STATION_ID_UPDATE_RES_T tRes;
} CCLIEFB_STATION_ID_UPDATE_PCK_T;


/******************************************************************************/
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(CCLIEFBIF_PUBLIC_H)
#endif

#endif
